<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Addition extends Model 
{

    protected $table = 'additions';
    public $timestamps = true;
    protected $fillable = array('type', 'name', 'price', 'user_id');

    public function products()
    {
        return $this->belongsToMany('App\Models\Product', 'product_id');
    }

    public function users()
    {
        return $this->belongsTo('App\User', 'user_id');
    }

    public function carts()
    {
        return $this->belongsToMany('App\Models\Cart', 'cart_id');
    }

    public function orders()
    {
        return $this->belongsToMany('App\Models\Order', 'order_id')->withPivot(['price','product_id']);
    }

}